;
;                                                              
;            WA_Link SDK v1.0 by the bASE crew                 
;                    for WA Link 1.2+                          
;                                                              
;         Offical site: http://www.base.is/thecrew/            
;                                                              
;             mIRC Script by Dagur Hilmarsson                  
;                                                              
;

;
;                      LOCAL IDENTIFIERS                       
;

alias -l wa.dll {
  ; ====================== START EDIT HERE ========================
  ; By default the SDK has to be in the same folder as WA_Link.dll
  return $scriptdir $+ WA_link.dll
  ; ====================== STOP EDIT HERE =========================
}

alias -l wa.donebar {
  ; ====================== START EDIT HERE ========================
  ; Edit these settings if you want to change the output of the "donebar".
  ; You can use colours and other control codes.

  ; This shows the character (pricks) that are done in the bar, default is '|'.
  var %wa.done = |

  ; This shows the character (lines) that are left in the bar, default is '-'.
  var %wa.remaining = -

  ; This shows the character which remarks the beggining of the bar.
  ; If you don't want any marks on the left side, type '$null' (without the quotes) instead of '['.
  var %wa.left = [

  ; This shows the character which remarks the end of the bar.
  ; If you don't want any marks on the right side, type '$null' (without the quotes) instead of ']'.
  var %wa.right = ]
  ; ====================== STOP EDIT HERE =========================

  var %wa.info = $int($calc(($dll($wa.dll, WA_Link_Raw_Stats, POSSEC) / $dll($wa.dll, WA_Link_Raw_Stats, TRACKSEC)) * 100))
  var %wa.x = 10
  var %wa.bar = $null
  :again
  if $len(%wa.bar) == 10 { goto end }
  if %wa.info >= %wa.x {
    var %wa.bar = %wa.bar $+ %wa.done
    inc %wa.x 10
    goto again
  }
  else {
    var %wa.bar = %wa.bar $+ %wa.remaining
    inc %wa.x 10
    goto again
  }
  :end
  return %wa.left $+ %wa.bar $+ %wa.right
}

alias -l wa.savepl {
  ; ====================== START EDIT HERE ========================

  ; Location of temp file which is used when the playlist is generated.
  ; Default: $scriptdir $+ Playlist.tmp
  var %wa.var.1 = $scriptdir $+ Playlist.tmp

  ; Location of the mp3 (winamp playlist file)
  ; Default: $wa.info(wadir,s) $+ Winamp.m3u
  var %wa.var.2 = $wa.info(wadir,s) $+ Winamp.m3u

  ; Location of output playlist
  ; Default: $scriptdir $+ Playlist.txt
  var %wa.var.3 = $scriptdir $+ Playlist.txt

  ; ====================== STOP EDIT HERE =========================

  var %WA.Temp.Playlist.File
  var %WA.Temp.Playlist.Line
  var %WA.Temp.Playlist.Line.Length

  var %WA.Temp.Playlist.Track.Number
  var %WA.Temp.Playlist.Track.Length
  var %WA.Temp.Playlist.Track.Length.Min
  var %WA.Temp.Playlist.Track.Length.Sec
  var %WA.Temp.Playlist.Track.Length.Len

  var %WA.Temp.Playlist.Counter

  var %wa.tmp = $wa.do(writepl)

  set %WA.Temp.Playlist.Track.Number 1

  set %WA.Temp.Playlist.File %wa.var.2

  filter -ffc %WA.Temp.Playlist.File %wa.var.1 *EXTINF*
  .remove %wa.var.3

  while ($read(%wa.var.1,%WA.Temp.Playlist.Track.Number) != $null) {
    ;Read a line (track) from the playlist and process it
    {
      set %WA.Temp.Playlist.Line $read(%wa.var.1,%WA.Temp.Playlist.Track.Number)
      set %WA.Temp.Playlist.Line.Length $len(%WA.Temp.Playlist.Line)
      set %WA.Temp.Playlist.Line $right(%WA.Temp.Playlist.Line,$calc(%WA.Temp.Playlist.Line.Length - 8))
      set %WA.Temp.Playlist.Line.Length $len(%WA.Temp.Playlist.Line)

      set %WA.Temp.Playlist.Counter 1

      while ($right($left(%WA.Temp.Playlist.Line,%WA.Temp.Playlist.Counter),1) != $chr(44)) {
        inc %WA.Temp.Playlist.Counter
      }

      set %WA.Temp.Playlist.Track.Length $left(%WA.Temp.Playlist.Line,$calc(%WA.Temp.Playlist.Counter - 1))    
      set %WA.Temp.Playlist.Track.Length.Len $len(%WA.Temp.Playlist.Track.Length)
      inc %WA.Temp.Playlist.Track.Length.Len

      while (%WA.Temp.Playlist.Track.Length > 60) {
        dec %WA.Temp.Playlist.Track.Length 60
        inc %WA.Temp.Playlist.Track.Length.Min 1
      }
      set %WA.Temp.Playlist.Track.Length.Sec %WA.Temp.Playlist.Track.Length

      set %WA.Temp.Playlist.Line $right(%WA.Temp.Playlist.Line,$calc(%WA.Temp.Playlist.Line.Length - %WA.Temp.Playlist.Track.Length.Len)))
    }

    ;Write to file
    {
      if (%WA.Temp.Playlist.Track.Length.Sec < 10) {
        set %WA.Temp.Playlist.Track.Length.Sec 0 $+ %WA.Temp.Playlist.Track.Length.Sec
      }
      write %wa.var.3 %WA.Temp.Playlist.Track.Number $+ . %WA.Temp.Playlist.Line $chr(91) $+ %WA.Temp.Playlist.Track.Length.Min $+ : $+ %WA.Temp.Playlist.Track.Length.Sec $+ $chr(93)
    }

    ;Increment variable to read next line (track) and reset all track-length-related variables
    set %WA.Temp.Playlist.Track.Length
    set %WA.Temp.Playlist.Track.Length.Min
    set %WA.Temp.Playlist.Track.Length.Sec
    set %WA.Temp.Playlist.Line.Length
    set %WA.Temp.Playlist.Line
    set %WA.Temp.Playlist.Counter

    inc %WA.Temp.Playlist.Track.Number
  }
  .remove %wa.var.1
}



;
;                GLOBAL WINAMP INFO IDENTIFIER                 
;

alias wa.info {
  if $1 == about { }
  elseif $1 == sdkversion { 
    var %wa.info = 1.0
  }
  elseif $1 == dllversion { 
    var %wa.info = $false
  }
  elseif $1 == version { 
    var %wa.info = $dll($wa.dll, WA_Link_Raw_Stats, VERSION)
    if %wa.info == $null { var %wa.info = $false }
  }
  elseif $1 == title { 
    var %wa.info = $dll($wa.dll, WA_Link_Raw_Stats, TITLE) 
    if %wa.info == $null { var %wa.info = $false }
  }
  elseif $1 == artist { 
    var %wa.info = $dll($wa.dll, WA_Link_Raw_Stats, ARTIST)
    if %wa.info == $null { var %wa.info = $false }
  }
  elseif $1 == album { 
    var %wa.info = $dll($wa.dll, WA_Link_Raw_Stats, ALBUM) 
    if %wa.info == $null { var %wa.info = $false }
  }
  elseif $1 == genre { 
    var %wa.info = $dll($wa.dll, WA_Link_Raw_Stats, GENRE) 
    if %wa.info == $null { var %wa.info = $false }
  }
  elseif $1 == comment { 
    var %wa.info = $dll($wa.dll, WA_Link_Raw_Stats, COMMENT) 
    if %wa.info == $null { var %wa.info = $false }
  }
  elseif $1 == year { 
    var %wa.info = $dll($wa.dll, WA_Link_Raw_Stats, YEAR) 
    if %wa.info == $null { var %wa.info = $false }
  }
  elseif $1 == tracksec {
    var %wa.info = $dll($wa.dll, WA_Link_Raw_Stats, TRACKSEC) 
    if $2 == ms { var %wa.info = $asctime(%wa.info,nn:ss) }
    if %wa.info == $null { var %wa.info = $false }
  }
  elseif $1 == possec {
    var %wa.info = $dll($wa.dll, WA_Link_Raw_Stats, POSSEC)
    if $2 == ms { var %wa.info = $asctime(%wa.info,nn:ss) }
    if %wa.info == $null { var %wa.info = $false }
  }
  elseif $1 == state {
    var %wa.info = $dll($wa.dll, WA_Link_Raw_Stats, STATE)
    if %wa.info == $null { var %wa.info = $false }   
  }
  elseif $1 == filetype { 
    var %wa.info = $dll($wa.dll, WA_Link_Raw_Stats, FILETYPE)
    if %wa.info == $null { var %wa.info = $false }
  }
  elseif $1 == trackfilename { 
    var %wa.info = $dll($wa.dll, WA_Link_Raw_Stats, TRACKFILENAME)
    if $2 == s { var %wa.info = $shortfn(%wa.info) }
    if %wa.info == $null { var %wa.info = $false }
  }
  elseif $1 == trackno {
    var %wa.info = $dll($wa.dll, WA_Link_Raw_Stats, TRACKNO) 
    if %wa.info == $null { var %wa.info = $false }
  }
  elseif $1 == channels {
    var %wa.info = $dll($wa.dll, WA_Link_Raw_Stats, CHANNELS) 
    if %wa.info == $null { var %wa.info = $false }
  }
  elseif $1 == bitrate {
    var %wa.info = $dll($wa.dll, WA_Link_Raw_Stats, BITRATE) 
    if %wa.info == $null { var %wa.info = $false }
  }
  elseif $1 == samplerate { 
    var %wa.info = $dll($wa.dll, WA_Link_Raw_Stats, SAMPLERATE)
    if %wa.info == $null { var %wa.info = $false }
  }
  elseif $1 == tracksize { 
    var %wa.info = $dll($wa.dll, WA_Link_Raw_Stats, TRACKSIZE)
    if $2 == m { var %wa.info = $bytes(%wa.info,M3) }
    if %wa.info == $null { var %wa.info = $false }
  }
  elseif $1 == getshuffle { 
    var %wa.info = $dll($wa.dll, WA_Link_Raw_Stats, GETSHUFFLE)
    if %wa.info == $null { var %wa.info = $false }
  }
  elseif $1 == getrepeat { 
    var %wa.info = $dll($wa.dll, WA_Link_Raw_Stats, GETREPEAT) 
    if %wa.info == $null { var %wa.info = $false }
  }
  elseif $1 == wadir { 
    var %wa.info = $dll($wa.dll, WA_Link_Raw_Stats, WADIR) 
    if $2 == s { var %wa.info = $shortfn(%wa.info) }
    if %wa.info == $null { var %wa.info = $false }
  }
  elseif $1 == donebar {
    var %wa.info = $wa.donebar 
    if %wa.info == $null { var %wa.info = $false }
  }
  else { var %wa.info = $chr(36) $+ null }
  return %wa.info
}

;
;                GLOBAL THEME PROCESS IDENTIFIER               
;

alias wa.stats {
  var %wa.stats.file = $shortfn($1)
  if !$exists(%wa.stats.file) { var %wa.stats = $false }
  else {
    var %wa.stats = $dll($wa.dll, WA_Link_Stats, %wa.stats.file)
    var %WA.Stats = $replace(%WA.Stats,$chr(160),$chr(32),$chr(44),$chr(160))
    var %WA.Stats = $replace(%WA.Stats,$chr(44),$chr(160))
    var %WA.Stats = $eval(%WA.Stats,2)
    var %WA.Stats = $replace(%WA.Stats,$chr(160),$chr(44))
  }
  return %wa.stats
}

;
;             GLOBAL WINAMP COMMANDS IDENTIFIER                
;

alias wa.command {
  if $1 == next { var %wa.com = $dll($wa.dll, WA_Link_Command, NEXT) }
  elseif $1 == play { var %wa.com = $dll($wa.dll, WA_Link_Command, PLAY) } 
  elseif $1 == prev { var %wa.com = $dll($wa.dll, WA_Link_Command, PREV) } 
  elseif $1 == pause { var %wa.com = $dll($wa.dll, WA_Link_Command, PAUSE) } 
  elseif $1 == stop { var %wa.com = $dll($wa.dll, WA_Link_Command, STOP) } 
  elseif $1 == bofpl { var %wa.com = $dll($wa.dll, WA_Link_Command, BOFPL) } 
  elseif $1 == eofpl { var %wa.com = $dll($wa.dll, WA_Link_Command, EOFPL) } 
  elseif $1 == fadestop { var %wa.com = $dll($wa.dll, WA_Link_Command, FADESTOP) } 
  elseif $1 == FFW5 { var %wa.com = $dll($wa.dll, WA_Link_Command, FFW5) } 
  elseif $1 == REW5 { var %wa.com = $dll($wa.dll, WA_Link_Command, REW5) } 
  elseif $1 == shuffle { var %wa.com = $dll($wa.dll, WA_Link_Command, SHUFFLE) } 
  elseif $1 == repeat { var %wa.com = $dll($wa.dll, WA_Link_Command, REPEAT) } 
  elseif $1 == hide { var %wa.com = $dll($wa.dll, WA_Link_Command, HIDE) } 
  elseif $1 == show { var %wa.com = $dll($wa.dll, WA_Link_Command, SHOW) } 
  elseif $1 == ontop { var %wa.com = $dll($wa.dll, WA_Link_Command, ONTOP) } 
  elseif $1 == playlist { var %wa.com = $dll($wa.dll, WA_Link_Command, playlist) } 
  elseif $1 == plshade { var %wa.com = $dll($wa.dll, WA_Link_Command, PLSHADE) } 
  elseif $1 == shade { var %wa.com = $dll($wa.dll, WA_Link_Command, SHADE) } 
  elseif $1 == EQ { var %wa.com = $dll($wa.dll, WA_Link_Command, EQ) } 
  elseif $1 == open { var %wa.com = $dll($wa.dll, WA_Link_Command, OPEN) } 
  elseif $1 == visplug { var %wa.com = $dll($wa.dll, WA_Link_Command, VISPLUG) } 
  elseif $1 == close { var %wa.com = $dll($wa.dll, WA_Link_Command, CLOSE) } 
  elseif $1 == start { var %wa.com = $dll($wa.dll, WA_Link_Command, START) } 
  elseif $1 == jump { var %wa.com = $dll($wa.dll, WA_Link_Command, JUMP $2) }
  elseif $1 == find { 
    if $2 == -j { 
      var %wa.com = $dll($wa.dll, WA_Link_Command, FIND $3-) 
      var %wa.com = $dll($wa.dll, WA_Link_Command, JUMP %wa.com)
    }
    else {
      var %wa.com = $dll($wa.dll, WA_Link_Command, FIND $2-) 
      if %wa.com == -2 { var %wa.com = $chr(36) $+ null }
      return %wa.com
    }
  }
  elseif $1 == seek { var %wa.com = $dll($wa.dll, WA_Link_Command, SEEK $2) }
  elseif $1 == vol { var %wa.com = $dll($wa.dll, WA_Link_Command, VOL $2) }
  elseif $1 == pan { var %wa.com = $dll($wa.dll, WA_Link_Command, PAN $2) }
}

;
;            GLOBAL WINAMP COMMANDS IDENTIFIER #2              
;

alias wa.do {
  if $1 == writepl { var %wa.com = $dll($wa.dll, WA_Link_Command, WRITEPL) } 
  elseif $1 == savepl { wa.savepl } 
  elseif $1 == pladdd {
    .set %WA.Files.Add
    .set %WA.Files.Add.Dir $sdir(c:\,Select dir)
    .set %WA.Files.Add.Counter 1
    window -lh @WA.FilesAdd
    var %wa.com = $findfile(%WA.Files.Add.Dir,*.mp3,@WA.FilesAdd,0,@WA.FilesAdd)
    var %wa.com = $findfile(%WA.Files.Add.Dir,*.wma,@WA.FilesAdd,0,@WA.FilesAdd)
    var %wa.com = $findfile(%WA.Files.Add.Dir,*.wav,@WA.FilesAdd,0,@WA.FilesAdd)
    var %wa.com = $findfile(%WA.Files.Add.Dir,*.cda,@WA.FilesAdd,0,@WA.FilesAdd)
    var %wa.com = $findfile(%WA.Files.Add.Dir,*.mid,@WA.FilesAdd,0,@WA.FilesAdd)
    while %WA.Files.Add.Counter <= $line(@WA.FilesAdd,0,1) {
      run $dll($wa.dll,WA_Link_Raw_Stats,WADIR) $+ winamp.exe /add " $+ $line(@WA.FilesAdd,%WA.Files.Add.Counter,1) $+ "
      inc %WA.Files.Add.Counter
    }
    window -c @WA.FilesAdd
  }
  elseif $1 == pladdf {
    run $dll($wa.dll,WA_Link_Raw_Stats,WADIR) $+ winamp.exe /add " $+ $sfile(c:\,Select track) $+ "
  }
  elseif $1 == pladd {
    if $2 == $null {
      run $dll($wa.dll,WA_Link_Raw_Stats,WADIR) $+ winamp.exe /add $$?="Full path or URL. Enclose multiple tracks with double quotes (ASCII #34)"
    }
    else {
      run $dll($wa.dll,WA_Link_Raw_Stats,WADIR) $+ winamp.exe /add $2-
    }
  }
}

; End of mIRC Script
