{

                     WA Link 1.2 - Made by the bASE crew 03.27.2002           
                            www.base.is/thecrew base@base.is                  
                        DLL programming by Sveinn Steinarsson                 

}

library WA_Link;

{ Important note about DLL memory management: ShareMem must be the
  first unit in your library's USES clause AND your project's (select
  Project-View Source) USES clause if your DLL exports any procedures or
  functions that pass strings as parameters or function results. This
  applies to all strings passed to and from your DLL--even those that
  are nested in records and classes. ShareMem is the interface unit to
  the BORLNDMM.DLL shared memory manager, which must be deployed along
  with your DLL. To avoid using BORLNDMM.DLL, pass string information
  using PChar or ShortString parameters. }

uses
  SysUtils,
  Windows,
  Classes,
  Messages,
  Registry;

const
  // Constants for Winamp
  WINAMP_BUTTON_PREVIOUS = 40044;
  WINAMP_BUTTON_PLAY     = 40045;
  WINAMP_BUTTON_PAUSE    = 40046;
  WINAMP_BUTTON_STOP     = 40047;
  WINAMP_FADE_STOP       = 40147;
  WINAMP_BUTTON_NEXT     = 40048;
  WINAMP_VOLUMEUP        = 40058;
  WINAMP_VOLUMEDOWN      = 40059;
  WINAMP_TOGGLE_SHUFFLE  = 40023;
  WINAMP_TOGGLE_REPEAT   = 40022;
  EXEC_VIS_PLUGING       = 40192;
  WINAMP_FFWD5S          = 40148;
  WINAMP_REW5S           = 40144;
  WINAMP_CLOSE           = 40001;
  WINAMP_BOF_PLAYLIST    = 40154;
  WINAMP_EOF_PLAYLIST    = 40158;
  WINAMP_TOGGLE_STAY_TOP = 40019;
  WINAMP_OPEN            = 40029;
  WINAMP_TOGGLE_PL       = 40040;
  WINAMP_TOGGLE_WA_SHADE = 40064;
  WINAMP_TOGGLE_PL_SHADE = 40266;
  WINAMP_TOGGLE_EQ       = 40036;

  WINAMP_WRITE_PLAYLIST  = 120;
  WINAMP_GET_TRACKLENPOS = 105;
  WINAMP_GET_TRACKNO     = 125;
  WINAMP_GET_PLAYSTATE   = 104;
  WINAMP_GET_SHUFFLE     = 250;
  WINAMP_GET_REPEAT      = 251;
  WINAMP_SET_PLAYLIST    = 121;
  WINAMP_SET_SETVOLUME   = 122;
  WINAMP_SET_SETPANNING  = 123;
  WINAMP_SEEK            = 106;
  WINAMP_GET_RATE        = 126;

  // Theme constants
  IS_PLAYING             = 1; // Is playing parameter
  IS_STOPPED             = 2; // Is stopped parameter
  IS_PAUSED              = 3; // Is paused parameter
  WINAMP_NOT_RUNNING     = 4; // Winamp isn't running parameter
  TITLE                  = 5; // Title parameter
  ARTIST                 = 6; // Artist parameter
  ALBUM                  = 7; // Album parameter
  YEAR                   = 8; // Year parameter
  GENRE                  = 9; // Genre parameter
  COMMENT                = 10; // Comment parameter
  TRACK_LENGTH           = 11; // Track length parameter
  DONEBAR                = 12; // What to use as done bar parameter
  LEFTBAR                = 13; // What to use as remaining bar parameter
  OUT_ORDER              = 14; // In what order stats is echoed
  CANT_FIND_PLAYLIST     = 15; // Error. Cant find playlist parameter
  CANT_GET_FROM_WINAMP   = 16; // Error. Winamp doesn't return playstate parameter

  // Version constants
  WA_LINK_MADE_BY        = 'Made by'+#13+#10+  // Credits info
                           'the bASE crew'+#13+#10+
                           'www.base.is/thecrew/'+#13+#10+
                           'base@base.is';
  WA_LINK_VERSION        = 'WA_Link v1.2'; // Version info

  // Constants for genre types for ID3v1.x TAG's
  FGenresArray: array[0..125] of String =
 ('Blues', 'Classic Rock', 'Country', 'Dance', 'Disco', 'Funk', 'Grunge', 'Hip-Hop', 'Jazz', 'Metal', // 0 - 9
  'New Age', 'Oldies', 'Other', 'Pop', 'R&B', 'Rap', 'Reggae', 'Rock', 'Techno', 'Industrial', // 10 - 19
  'Alternative', 'Ska', 'Death Metal', 'Pranks', 'Soundtrack', 'Euro-Techno', 'Ambient', 'Trip-Hop', 'Vocal', 'Jazz+Funk', // 20 - 29
  'Fusion', 'Trance', 'Classical', 'Instrumental', 'Acid', 'House', 'Game', 'Sound Clip', 'Gospel', 'Noise', // 30 - 39
  'AlternRock', 'Bass', 'Soul', 'Punk', 'Space', 'Meditative', 'Instrumental Pop', 'Instrumental Rock', 'Ethnic', 'Gothic', // 40 - 49
  'Darkwave', 'Techno-Industrial', 'Electronic', 'Pop-Folk', 'Eurodance', 'Dream', 'Southern Rock', 'Comedy', 'Cult', 'Gangsta', // 50 - 59
  'Top 40', 'Christian Rap', 'Pop/Funk', 'Jungle', 'Native American', 'Cabaret', 'New Wave', 'Psychadelic', 'Rave', 'Showtunes', // 60 - 69
  'Trailer', 'Lo-Fi', 'Tribal', 'Acid Punk', 'Acid Jazz', 'Polka', 'Retro', 'Musical', 'Rock & Roll', 'Hard Rock', // 70 - 79
  'Folk', 'Folk-Rock', 'National Folk', 'Swing', 'Fast Fusion', 'Bebob', 'Latin', 'Revival', 'Celtic', 'Bluegrass', // 80 - 89
  'Avantgarde', 'Gothic Rock', 'Progressive Rock', 'Psychedelic Rock', 'Symphonic Rock', 'Slow Rock', 'Big Band', 'Chorus', 'Easy Listening', 'Acoustic', // 90 - 99
  'Humour', 'Speech', 'Chanson', 'Opera', 'Chamber Music', 'Sonata', 'Symphony', 'Booty Brass', 'Primus', 'Porn Groove', // 100 - 109
  'Satire', 'Slow Jam', 'Club', 'Tango', 'Samba', 'Folklore', 'Ballad', 'Poweer Ballad', 'Rhytmic Soul', 'Freestyle', // 110 - 119
  'Duet', 'Punk Rock', 'Drum Solo', 'A Capela', 'Euro-House', 'Dance Hall'); // 120 - 125

  // Constants for ID3v2 TAG's
  ID3V2_FRAME_COUNT       = 7;     // Max. number of supported tag frames
  ID3V2_ID                = 'ID3'; // ID3v2 tag ID
  TAG_VERSION_2_3         = 3;     // Code for ID3v2.3.x tag
  ID3V2_FRAME: array [1..ID3V2_FRAME_COUNT] of string =
    ('TIT2', 'TPE1', 'TALB', 'TRCK', 'TYER', 'TCON', 'COMM'); // Names of supported tag frames

var
 // Global Array's for theme's
 IniText: array[1..16] of String;
 InfoText: array[4..11] of String;

type
  // Standard mIRC type
  TLoadInfo = packed record
    mVersion : DWORD;
    mHwnd    : HWND;
    mKeep    : Boolean;
  end;
  PLoadInfo = ^TLoadInfo;

  // ID3v2 frame header
  FrameHeader = record
    ID   : array [1..4] of Char; // Frame ID
    Size : Integer;              // Size excluding header
    Flags: Word;                 // Flags
  end;

  // ID3v2 header data (for internal use)
  TagInfo = record
    // Real structure of ID3v2 header
    ID      : array [1..3] of Char; // Always "ID3"
    Version : Byte;                 // Version number
    Revision: Byte;                 // Revision number
    Flags   : Byte;                 // Flags of tag
    Size    : array [1..4] of Byte; // Tag size excluding header
    // Extended data
    FileSize: Integer;              // File size (bytes)
    Frame    : array [1..ID3V2_FRAME_COUNT] of string; // Information from frames
  end;

{$R *.RES}

{

                       mIRC STANDARD LOAD/UNLOAD Functions                    

}

// mIRC loads the DLL
procedure LoadDll(LoadInfo: PLoadInfo); stdcall; export;
begin
  LoadInfo.mKeep := FALSE; // Release DLL after use
end;


// mIRC unloads the DLL
procedure UnloadDll(mTimeOut: integer); stdcall; export;
begin
  // Take no action when DLL is unloaded
end;

{

                                WINAMP Functions                              

}

// Get the bitrate of current playing track
function WA_Get_TrackSize(TrackFileName: string): Cardinal;
var
  FileHandle : integer;
begin
  FileHandle := FileOpen(TrackFileName, fmShareDenyNone);

  If FileHandle <> -1 then
    result := GetFileSize(FileHandle,nil)
  else
    result := 0;

  fileclose(FileHandle);
end;

// Get the channels of current playing track. 1 = Mono 2 = Stereo
function WA_Get_Channels(hwndWinamp : THandle): string;
begin
  Result := inttostr(SendMessage(hwndWinamp,WM_USER,2,WINAMP_GET_RATE));
end;

// Get the sample of current playing track
function WA_Get_SampleRate(hwndWinamp : THandle): string;
begin
  Result := inttostr(SendMessage(hwndWinamp,WM_USER,0,WINAMP_GET_RATE));
end;

// Get the bitrate of current playing track
function WA_Get_Bitrate(hwndWinamp : THandle): string;
begin
  Result := inttostr(SendMessage(hwndWinamp,WM_USER,1,WINAMP_GET_RATE));
end;

// Get shuffle state from winamp
function WA_Get_Shuffle(hwndWinamp : THandle): Boolean;
begin
  Result:=Boolean(SendMessage(hwndWinamp,WM_USER,0,WINAMP_GET_SHUFFLE));
end;

// Get repeat state from winamp
function WA_Get_Repeat(hwndWinamp : THandle): Boolean;
begin
  Result:=Boolean(SendMessage(hwndWinamp,WM_USER,0,WINAMP_GET_REPEAT));
end;

// Command winamp to toggle EQ hide/show
procedure WA_Toggle_EQ(hwndWinamp : THandle);
begin
  SendMessage(hwndWinamp,WM_COMMAND,WINAMP_TOGGLE_EQ,0);
end;

// Command winamp to toggle playlist hide/show
procedure WA_Toggle_PL(hwndWinamp : THandle);
begin
  SendMessage(hwndWinamp,WM_COMMAND,WINAMP_TOGGLE_PL,0);
end;

// Command winamp to toggle winamp shade
procedure WA_Toggle_Shade(hwndWinamp : THandle);
begin
  SendMessage(hwndWinamp,WM_COMMAND,WINAMP_TOGGLE_WA_SHADE,0);
end;

// Command winamp to toggle playlist shade
procedure WA_Toggle_PL_Shade(hwndWinamp : THandle);
begin
  SendMessage(hwndWinamp,WM_COMMAND,WINAMP_TOGGLE_PL_SHADE,0);
end;

// Command winamp to open load dialog
procedure WA_Open(hwndWinamp : THandle);
begin
  SendMessage(hwndWinamp,WM_COMMAND,WINAMP_OPEN,0);
end;

// Command winamp to go and hide
procedure WA_Hide(hwndWinamp : THandle);
begin
  ShowWindow(hwndWinamp, SW_HIDE);
end;

// Command winamp to show
procedure WA_Show(hwndWinamp : THandle);
begin
  ShowWindow(hwndWinamp, SW_SHOW);
end;

// Command winamp to restore the winamp window
procedure WA_Restore(hwndWinamp : THandle);
begin
  ShowWindow(hwndWinamp, SW_RESTORE);
end;

// Command winamp to minimize the winamp window
procedure WA_Minimize(hwndWinamp : THandle);
begin
  ShowWindow(hwndWinamp, SW_MINIMIZE);
end;

// Command winamp to toggle stay on top
procedure WA_Toggle_Stay_on_top(hwndWinamp : THandle);
begin
  SendMessage(hwndWinamp,WM_COMMAND,WINAMP_TOGGLE_STAY_TOP,0);
end;

// Command winamp to play
procedure WA_Play_Track(hwndWinamp : THandle);
begin
  SendMessage(hwndWinamp,WM_COMMAND,WINAMP_BUTTON_PLAY,0);
end;

// Command winamp to stop
procedure WA_Stop_Track(hwndWinamp : THandle);
begin
  SendMessage(hwndWinamp,WM_COMMAND,WINAMP_BUTTON_STOP,0);
end;

// Command winamp to pause
procedure WA_Pause_Track(hwndWinamp : THandle);
begin
  SendMessage(hwndWinamp,WM_COMMAND,WINAMP_BUTTON_PAUSE,0);
end;

// Jumps to a certain track number in winamp
procedure WA_Jump_Playlist(hwndWinamp : THandle; TrackNo: Word);
begin
  SendMessage(hwndWinamp,WM_USER,TrackNo-1,WINAMP_SET_PLAYLIST);
  WA_Play_Track(hwndWinamp);
end;

// Command winamp to play the first song in the playlist
procedure WA_BOF_Playlist(hwndWinamp : THandle);
begin
   SendMessage(hwndWinamp,WM_COMMAND,WINAMP_BOF_PLAYLIST,0);
end;

// Command winamp to play the last song in the playlist
procedure WA_EOF_Playlist(hwndWinamp : THandle);
begin
   SendMessage(hwndWinamp,WM_COMMAND,WINAMP_EOF_PLAYLIST,0);
end;

// Command winamp to fade out and stop
procedure WA_Fade_Stop(hwndWinamp : THandle);
begin
   SendMessage(hwndWinamp,WM_COMMAND,WINAMP_FADE_STOP,0);
end;

// Command winamp tp close
procedure WA_Close(hwndWinamp : THandle);
begin
  SendMessage(hwndWinamp,WM_COMMAND,WINAMP_CLOSE,0);
end;

// Command winamp to jump forward 5 sec
procedure WA_Forward_5_Sec(hwndWinamp : THandle);
begin
  SendMessage(hwndWinamp,WM_COMMAND,WINAMP_FFWD5S,0);
end;

// Command winamp to jump backward 5 sec
procedure WA_Backward_5_Sec(hwndWinamp : THandle);
begin
  SendMessage(hwndWinamp,WM_COMMAND,WINAMP_REW5S,0);
end;

// Command winamp to start selected VIS plugin
procedure WA_Exec_VisPlugin(hwndWinamp : THandle);
begin
  SendMessage(hwndWinamp,WM_COMMAND,EXEC_VIS_PLUGING,0);
end;

// Command winamp to toggle shuffle
procedure WA_Toggle_Shuffle(hwndWinamp : THandle);
begin
  SendMessage(hwndWinamp,WM_COMMAND,WINAMP_TOGGLE_SHUFFLE,0);
end;

// Command winamp to toggle repeat mode
procedure WA_Toggle_Repeat(hwndWinamp : THandle);
begin
  SendMessage(hwndWinamp,WM_COMMAND,WINAMP_TOGGLE_REPEAT,0);
end;

// Command winamp to set volume up by one
procedure WA_Volume_Up(hwndWinamp : THandle);
begin
   SendMessage(hwndWinamp,WM_COMMAND,WINAMP_VOLUMEUP,0);
end;

// Command winamp to set volume down by one
procedure WA_Volume_Down(hwndWinamp : THandle);
begin
   SendMessage(hwndWinamp,WM_COMMAND,WINAMP_VOLUMEDOWN,0);
end;

// Command winamp to set volume (0 lowest, 255 highest)
procedure WA_Volume_Set(hwndWinamp : THandle; Volume: byte);
begin
  // Calculate the correct value based on input (0..100)
  // This is to simplify the values in mIRC
  Volume := trunc(Volume*2.55);
  SendMessage(hwndWinamp,WM_USER,Volume,WINAMP_SET_SETVOLUME);
end;

// Command winamp to set panning (128..254 left, 255 middle, 1..127 right)
procedure WA_Panning_Set(hwndWinamp : THandle; Panning: Shortint);
var
  PanByte : byte;
begin
  // Calculate the correct value based on input (-100..100)
  // This is to simplify the values in mIRC
  if Panning > 0 then
  begin
    PanByte := Trunc(Panning * 1.28);
    if  PanByte > 127 then
      PanByte := 127;
  end
  else
  if Panning < 0 then
  begin
    PanByte := 128 - Trunc((100+Panning) * -1.28);
  end
  else
    PanByte := 255;

  SendMessage(hwndWinamp,WM_USER,PanByte,WINAMP_SET_SETPANNING);
end;

// Command winamp to go to previous track
procedure WA_Previous_Track(hwndWinamp : THandle);
begin
  SendMessage(hwndWinamp,WM_COMMAND,WINAMP_BUTTON_PREVIOUS,0);
end;

// Command winamp to go to next track
procedure WA_Next_Track(hwndWinamp : THandle);
begin
  SendMessage(hwndWinamp,WM_COMMAND,WINAMP_BUTTON_NEXT,0);
end;

// Returns what winamp version is running
Function WA_Version(hwndWinamp : THandle):String;
var
  Version : integer;
begin
  Version:=Integer(SendMessage(hwndWinamp,WM_USER,0,0));
  result:=copy(inttohex(Version,4),1,1)+'.'+copy(inttohex(Version,4),2,1)+copy(inttohex(Version,4),4,1);
End;

// Returns Winamp playstate. 0 = stop 1 = playing 3 = paused
function WA_Playstate(hwndWinamp : THandle):integer;
begin
  result := Integer(SendMessage(hwndWinamp,WM_USER,0,WINAMP_GET_PLAYSTATE));
End;

// Commands Winamp to save its default playlist (winampdir/winamp.m3u)
Procedure WA_WritePlayList(hwndWinamp : THandle);
begin
  SendMessage(hwndWinamp,WM_USER,0,WINAMP_WRITE_PLAYLIST);
End;

// Returns track number of current playing track
function WA_TrackNumber(hwndWinamp : THandle):integer;
begin
  result :=Integer(SendMessage(hwndWinamp,WM_USER,0,WINAMP_GET_TRACKNO))+1;
end;

// Returns the current songs length in seconds
Function WA_TrackLength(hwndWinamp : THandle):Integer;
begin
  Result:=Integer(SendMessage(hwndWinamp,WM_USER,1,WINAMP_GET_TRACKLENPOS));
End;

// Returns the current songs position in milliseconds
Function WA_TrackPos(hwndWinamp : THandle):Integer;
begin
  Result:=Integer(SendMessage(hwndWinamp,WM_USER,0,WINAMP_GET_TRACKLENPOS));
End;

// Commands Winamp to seek offset (Percentage of length)
Procedure WA_Seek_Offset(hwndWinamp : THandle; Offset: Byte);
var
  TrackLengtMSec : Longword;
  SetOffsetMSec  : LongWord;
begin
  TrackLengtMSec := WA_TrackLength(hwndWinamp) * 1000;

  SetOffsetMSec := trunc(TrackLengtMSec * (offset / 100));

  SendMessage(hwndWinamp,WM_USER,SetOffsetMSec,WINAMP_SEEK);
end;

// Returns in what dir Winamp is located
Function WA_WinAmpDir:String;
var
  Reg: TRegistry;
  Path :String;
begin
  Reg := TRegistry.Create;
  Result :='';
  try
    Reg.RootKey := HKEY_LOCAL_MACHINE;
     if Reg.OpenKey('\Software\Microsoft\Windows\CurrentVersion\Uninstall\Winamp', False) Then
     Begin
       Result:=Reg.ReadString('TestFile');
       Path:=Reg.ReadString('UninstallString');
       Path:=Uppercase(Path);
       If Path[1]='"' then Delete (Path,1,1);
         while Path[Length(Path)]<>'\' do Delete (Path,Length(Path),1);
           Result :=Path;
     End
     else
       Result := '';
  finally
    Reg.CloseKey;
    Reg.Free;
  end;
end;

// If track isn't a mp3 or has no tag, then you can ask winamp for its title and artist
Procedure WA_Window_Caption(hwndWinamp : THandle; var fTitle:String; VAR fArtist:String);
var
  Caption: array[0..256] of Char;
  Info : string;
  a,b: byte;

begin
  if GetWindowText(hwndWinamp, Caption, SizeOf(Caption)-1) <> 0 then
  begin
    Info := Caption;

    delete(info,length(info)-8,length(info));
    a := pos('.',Info)+2;
    b := pos('-',Info);

    if b = 0 then // Just title was found
    begin
      delete(info,1,a-1); // Deletes song number

      a := pos('.',Info); // Position on .

      if a = 0 then // Checks for extentions
        Ftitle := copy(Info,1,length(info))
      else
        Ftitle := copy(Info,1,pos('.',Info)-1); // Copy filename without extention
     end
     else
     begin // Title and Artist found
       b := b-1;
       fArtist := copy(Info,a,b-a);
       delete(info,1,b+2);
       Ftitle := copy(Info,1,length(info));
     end;
  end;
end;

// Find song in playlist
Function WA_Find_Playlist(hwndWinamp : THandle; TrackToFind: String):String;
var
  PlayList: TextFile;
  Line: string;
  TrackCounter: Word;
  FoundMatch: boolean;
  WinampPlaylist: string;

begin
  WinampPlaylist:= WA_WinAmpDir+'winamp.m3u';

  If FileExists(WinampPlaylist) then
  begin
    WA_WritePlayList(hwndWinamp);
    TrackToFind := uppercase(TrackToFind);
    TrackCounter := 0;
    FoundMatch := false;

  {$I-} // Disable the internal IO check
    AssignFile(PlayList,WinampPlaylist); // Loads default playlist
    Reset(PlayList);
  {$I+} // Reenable the internal IO check

    if IOResult = 0 then // If everything is OK...
    Begin
      While (NOT SeekEof (PlayList)) and (FoundMatch = false) Do // Goes through default playlist looking for a match
      Begin
        Readln(PlayList,Line);  // Reads one line out of the default playlist
        Line := UpperCase(Line);

        If ((Line[1])=('#')) Then // If the # is first character the TrackCounter is incremented
        Begin
          Inc(TrackCounter);
        End;

        if pos(TrackToFind,Line) > 0 then // This function only finds the first track number and returns it
        begin
          FoundMatch := true;
          result := inttostr(TrackCounter-1); // Return the tracknumber
        end;
      End;// While end

      CloseFile(PlayList);
    End;//IOResult

    if FoundMatch = false then
      result := '-2'; // Return -2 to mIRC if no track was found
  end;
end;

// Starts the winamp
procedure WA_Start;
var
  AmpDir : String;
begin
  AmpDir := WA_WinAmpDir;
  if AmpDir > '' then
    WinExec(PChar(AmpDir+'winamp.exe'), SW_NORMAL);
end;

// Returns the filename, tracknumber and filetype of current playing track
Function WA_GetTrackFileName(hwndWinamp : THandle; TrackNo:Integer; VAR TrackFileName:String; VAR FileType:String):Boolean;
var
  PlayList: TextFile;
  Line: string;
  LineCounter:Integer;
begin
  Result:=False; // Default the track info is not found
  If NOT FileExists (WA_WinAmpDir+'winamp.m3u') then
    WA_WritePlayList(hwndWinamp); // If the default playlist doen't exist, we need winamp to save it

{$I-} // Disable the internal IO checking
  AssignFile(PlayList,WA_WinAmpDir+'winamp.m3u');  // Loads the playlist
  Reset(PlayList);
{$I+} // Reenable the internal IO checking

  if IOResult = 0 then // If everything is OK...
  Begin
    LineCounter:=0;
    While ((LineCounter<TrackNo) AND (NOT SeekEof (PlayList))) Do
    Begin
      Readln(PlayList,Line);
      If Not ((Line[1])=('#')) Then
        Inc(LineCounter)
    End;  // While
    CloseFile(PlayList);
    If LineCounter=TrackNo then   // if we have found the correct line
    Begin
      TrackFileName:=Line;  // copy the info from the file
      FileType:=TrackFileName;

      while pos('\',FileType) > 0 do
        delete(FileType,1,pos('\',FileType));

      FileType := Copy(FileType,Length(FileType)-2,4);

      Result:=True; // data was found
    End;
  End; //IOResult
End;

{

                             ID3v2.3.x Functions                              

}

function ID3V2_ReadHeader(const FileName: string; var Tag: TagInfo): Boolean;
var
  SourceFile: file;
  Transferred: Integer;
begin
  try
    Result := true;
    AssignFile(SourceFile, FileName);
    // Set read-access and open file
    FileMode := 0;
    Reset(SourceFile, 1);
    // Read header and get file size
    BlockRead(SourceFile, Tag, 10, Transferred);
    Tag.FileSize := FileSize(SourceFile);
    CloseFile(SourceFile);
    // if transfer is not complete
    if Transferred < 10 then Result := false;
  except
    Result := false; // Error
  end;
end;

// Get tag version from the mp3 header
function ID3V2_GetVersionID(const Tag: TagInfo): Byte;
begin
  Result := Tag.Version;
end;

// Get total tag size
function ID3V2_GetTagSize(const Tag: TagInfo): Integer;
begin
  Result := Tag.Size[1] * $200000 +
            Tag.Size[2] * $4000 +
            Tag.Size[3] * $80 +
            Tag.Size[4] + 10;
  if Result > Tag.FileSize then Result := 0;
end;

// Swap 4 bytes
function ID3V2_Swap32(const Figure: Integer): Integer;
var
  ByteArray: array [1..4] of Byte absolute Figure;
begin
  Result := ByteArray[1] * $1000000 +
            ByteArray[2] * $10000 +
            ByteArray[3] * $100 +
            ByteArray[4];
end;

// Set tag item if supported frame found
procedure ID3V2_SetTagItem(const ID, Data: string; var Tag: TagInfo);
var
  Iterator: Byte;
begin
  for Iterator := 1 to ID3V2_FRAME_COUNT do
    if ID3V2_FRAME[Iterator] = ID then Tag.Frame[Iterator] := Data;
end;

// Read ID3v2 Frames
procedure ID3V2_ReadFrames(const FileName: string; var Tag: TagInfo);
var
  SourceFile: file;
  Frame: FrameHeader;
  Data: array [1..250] of Char;
  DataPosition: Integer;
begin
  try
    // Set read-access, open file
    AssignFile(SourceFile, FileName);
    FileMode := 0;
    Reset(SourceFile, 1);
    Seek(SourceFile, 10);
    // While we are still inside the ID3V2 tag...
    while (FilePos(SourceFile) < ID3V2_GetTagSize(Tag)) and (not EOF(SourceFile)) do
    begin
      FillChar(Data, SizeOf(Data), 0);
      // Read frame header and check frame ID
      BlockRead(SourceFile, Frame, 10);
      if not (Frame.ID[1] in ['A'..'Z']) then break;
      DataPosition := FilePos(SourceFile);
      // Read frame data and set tag item if frame supported
      BlockRead(SourceFile, Data, ID3V2_Swap32(Frame.Size) mod SizeOf(Data));
      ID3V2_SetTagItem(Frame.ID, Data, Tag);
      Seek(SourceFile, DataPosition + ID3V2_Swap32(Frame.Size));
    end;
    CloseFile(SourceFile);
  except
  end;
end;

// Extract genre from string
function ID3V2_ExtractGenre(const GenreString: string): string;
begin
  Result := Trim(GenreString);
  if Pos(')', Result) > 0 then Delete(Result, 1, LastDelimiter(')', Result));
end;

// Returns current songs ID3v2.x Tag Info. Returns false if no ID3v2.x was found
function ID3V2_GetID3(trackFileName: string; VAR fTitle:String; VAR fArtist:String; VAR fAlbum:String; VAR fYear:String; VAR fcomment:String; VAR fgenre:String):boolean;
var
  Tag: TagInfo;
  FSize: integer;
  FVersionID : byte;
  HeaderValid: boolean;
begin
  result := false;

  HeaderValid := ID3V2_ReadHeader(trackFileName, Tag);
  // Process data if loaded and header valid
  if (HeaderValid = true) and (Tag.ID = ID3V2_ID) then
  begin
     result := true;
    // Fill properties with header data
    FVersionID := ID3V2_GetVersionID(Tag);
    FSize := ID3V2_GetTagSize(Tag);
    // Get information from frames if version supported
    if (FVersionID = TAG_VERSION_2_3) and (FSize > 0) then
    begin
      ID3V2_ReadFrames(trackFileName, Tag);
      // Fill properties with data from frames
      FTitle := Trim(Tag.Frame[1]);
      FArtist := Trim(Tag.Frame[2]);
      FAlbum := Trim(Tag.Frame[3]);
      FYear := Trim(Tag.Frame[5]);
      FGenre := ID3V2_ExtractGenre(Tag.Frame[6]);
      FComment := Trim(Copy(Tag.Frame[7], 5, Length(Tag.Frame[7]) - 4));
    end
    else
      result := false;
  end;
end;

{

                             ID3v1 Functions                                  

}

// Returns current songs ID3v1.x Tag Info. Returns false if no ID3v1.x was found
function ID3V1_GetID3(trackFileName: string; VAR fTitle:String; VAR fArtist:String; VAR fAlbum:String; VAR fYear:String; VAR fcomment:String; VAR fgenre:String):boolean;
var
  s            : string;
  F            : TFileStream;
  I            : Integer;
  bGenre       : byte;
  TAG          : array [1..128] of Char;
begin
  F := TFilestream.Create(TrackFileName,fmOpenRead or fmShareDenyNone);
  F.seek(f.size - 128, soFromBeginning);
  f.read(tag,128);
  f.free;

  s:='';

  for i:=1 to 3 do begin
    s:=s + tag[i];
  end;

  // Check for tag
  if s<>'TAG' then begin
    result := false; // No tag
  end
  else
  begin
    ftitle:='';
    fartist:='';
    falbum:='';
    fyear:='';
    fcomment:='';

    for i:=4 to 33 do
      ftitle:=ftitle + tag[i];
    for i:=34 to 63 do
      fartist:=fartist + tag[i];
    for i:=64 to 93 do
      falbum:=falbum + tag[i];
    for i:=94 to 97 do
      fyear:=fyear + tag[i];
    for i:=98 to 127 do
      fcomment:=fcomment + tag[i]; 

    bGenre := byte(tag[128]);
    if bGenre > 125 then
      fgenre:=''
    else
      fgenre := FGenresArray[bGenre];

    ftitle:=trim(ftitle);
    fartist:=trim(fartist);
    falbum:=trim(falbum);
    fyear:=trim(fyear);
    fcomment:=trim(fcomment);

    result := true; // Tag found
  end;
end;

{

                             Theme Functions                                  

}

// Reads the Themefile into a string list
Procedure WA_Link_Read_IniFile(TextFileName: String);
var
  i : byte;
  F: TextFile;
begin
  if fileexists(TextFileName) then
  begin
    AssignFile(F, TextFileName);
    Reset(F);
    for i:= 1 to 16 do
      Readln(F,IniText[i]);
    CloseFile(F);
  end
  else // Didn't find theme file
    for i:= 1 to 16 do
      IniText[i] := 'Error! INI file not found';
end;

// Returns position, length, size, bitrate, samplerate and channels together in theme format
Function WA_TrackInfo(hwndWinamp : THandle;TrackFileName:string):String;
var
  TrackMin    : byte;
  Tracksec    : word;
  StrTrackSec : String;
  PosSec      : word;
  MinDone     : byte;
  SecDone     : byte;
  StrSecDone  : String;
  Percent     : byte;
  PercentStick: String;
  LengthInfo  : String;
  Bitrate     : String;
  Size        : String;
  SampleRate  : String;
  Channels    : String;
  i           : byte;

begin
  TrackSec := WA_TrackLength(hwndWinamp);
  PosSec := WA_TrackPos(hwndWinamp) div 1000;
  Bitrate := WA_Get_Bitrate(hwndWinamp);
  SampleRate := WA_Get_SampleRate(hwndWinamp);

  Channels := WA_Get_Channels(hwndWinamp);
  if Channels = '2' then
    Channels := 'Stereo'
  else
  if Channels = '1' then
    Channels := 'Mono';

  Percent := round((PosSec/TrackSec)*100);

  TrackMin := (TrackSec div 60);
  TrackSec := (TrackSec mod 60);

  If TrackSec < 10 then
    StrTrackSec := '0'+inttostr(TrackSec)
  else
    StrTrackSec := inttostr(TrackSec);

  MinDone := (PosSec div 60); // Whole minutes played
  SecDone := (PosSec mod 60); // Seconds played (Not including the minutes)

  If SecDone < 10 then
    StrSecDone := '0'+inttostr(SecDone) // This is just for looks
  else
    StrSecDone := inttostr(SecDone);

  LengthInfo := IniText[TRACK_LENGTH];

  LengthInfo := StringReplace(LengthInfo,'%MINLEN',inttostr(TrackMin),[rfReplaceAll,rfIgnoreCase]);
  LengthInfo := StringReplace(LengthInfo,'%SECLEN',StrTrackSec,[rfReplaceAll,rfIgnoreCase]);
  LengthInfo := StringReplace(LengthInfo,'%MINDONE',inttostr(MinDone),[rfReplaceAll,rfIgnoreCase]);
  LengthInfo := StringReplace(LengthInfo,'%SECDONE',StrSecDone,[rfReplaceAll,rfIgnoreCase]);
  LengthInfo := StringReplace(LengthInfo,'%PERCENT',inttostr(Percent),[rfReplaceAll,rfIgnoreCase]);
  LengthInfo := StringReplace(LengthInfo,'%BITRATE',Bitrate,[rfReplaceAll,rfIgnoreCase]);
  LengthInfo := StringReplace(LengthInfo,'%SAMPLERATE',SampleRate,[rfReplaceAll,rfIgnoreCase]);
  LengthInfo := StringReplace(LengthInfo,'%CHANNELS',Channels,[rfReplaceAll,rfIgnoreCase]);

  // Check if WA Link needs to calculate track size
  if pos('%SIZE',Uppercase(LengthInfo)) > 0 then
  begin
    Size := FormatFloat('0.00',(WA_Get_TrackSize(TrackFileName) / 1048576));
    Size := StringReplace(Size,',','.',[rfReplaceAll,rfIgnoreCase]); // Always use dot . as seperator

    LengthInfo := StringReplace(LengthInfo,'%SIZE',Size,[rfReplaceAll,rfIgnoreCase]);
  end;

  // Check if WA Link needs to generate a bar
  if pos('%BAR',Uppercase(LengthInfo)) > 0 then
  begin
    for i:=1 to 10 do
    begin
      if (Percent >= i*10) then
        PercentStick := PercentStick + IniText[DONEBAR]
      else
        PercentStick := PercentStick + IniText[LEFTBAR];
    end;
    LengthInfo := StringReplace(LengthInfo,'%BAR',PercentStick,[rfReplaceAll,rfIgnoreCase]);
  end;

  result := LengthInfo;
End;

{

                             Exported Functions                               

}

// Returns to mIRC the Winamp stat saccording to the theme.
function WA_Link_Stats( mWnd: hWnd; aWnd: hWnd; Data: PChar; Parms: PChar;
Show: Boolean; NoPause: Boolean ): Integer; export; stdcall;
var
  hwndWinamp   : THandle;

  TrackNo      : word;
  TrackFileName: String;
  WinAmpVersion: String;
  FileType     : String;

  fTitle       : String;
  fArtist      : String;
  fAlbum       : String;
  fYear        : String;
  fcomment     : string;
  fgenre       : string;

  OutString    : string;
  OrderStr     : string;

  WAPlaying    : String;
  Outdata      : Pchar;
  ID3Tag       : Boolean;

begin
  hwndWinamp := FindWindow('Winamp v1.x', nil);

  WA_Link_Read_IniFile(Data);

  if hwndWinamp > 0 then
  begin
    // Winamp is running

    WinAmpVersion := WA_Version(hwndWinamp); // Get Winamp version

    case WA_playState(hwndWinamp) of
      0: // Winamp is stopped
        begin
          OutData := Pchar(StringReplace(IniText[IS_STOPPED],'%Version',WinAMpVersion,[rfReplaceAll,rfIgnoreCase]));
        end;
      1: // Winamp is playing
        begin
          WA_WritePlayList(hwndWinamp);
          TrackNo := WA_TrackNumber(hwndWinamp);

          if WA_GetTrackFileName(hwndWinamp,TrackNo,TrackFileName,FileType) then
          begin
            // Found the default playlist
            ID3Tag := false;

            InfoText[TRACK_LENGTH] := WA_TrackInfo(hwndWinamp,TrackFileName);

            OrderStr := IniText[OUT_ORDER];
            WAPlaying := StringReplace(IniText[IS_PLAYING],'%Version',WinAMpVersion,[rfReplaceAll,rfIgnoreCase]);
            OutString := '';

            if UpperCase(FileType) = 'MP3' then
            begin
              if ID3V2_GetID3(trackFilename,fTitle,fArtist,fAlbum,fYear,fcomment,fgenre) then
                ID3Tag := True
              else
              if ID3V1_GetID3(trackFilename,fTitle,fArtist,fAlbum,fYear,fcomment,fgenre) then
                ID3Tag := True
            end;

            if ID3Tag = TRUE then
            begin
              if fTitle <> '' then
                InfoText[TITLE] := StringReplace(IniText[TITLE],'%TITLE',fTitle,[rfReplaceAll,rfIgnoreCase]);
              if fArtist <> '' then
                InfoText[ARTIST] := StringReplace(IniText[ARTIST],'%ARTIST',fArtist,[rfReplaceAll,rfIgnoreCase]);
              if fAlbum <> '' then
                InfoText[ALBUM] := StringReplace(IniText[ALBUM],'%ALBUM',fAlbum,[rfReplaceAll,rfIgnoreCase]);
              if fYear <> '' then
                InfoText[YEAR] := StringReplace(IniText[YEAR],'%YEAR',fYear,[rfReplaceAll,rfIgnoreCase]);
              if fgenre <> '' then
                InfoText[GENRE] := StringReplace(IniText[GENRE],'%GENRE',fgenre,[rfReplaceAll,rfIgnoreCase]);
              if fcomment <> '' then
                InfoText[COMMENT] := StringReplace(IniText[COMMENT],'%COMMENT',fcomment,[rfReplaceAll,rfIgnoreCase]);

              While OrderStr > '' do
              begin
                if (OrderStr[1] <> '') then
                begin
                  case OrderStr[1] of
                    'S': outstring := outstring + WAPlaying;
                    'T': outstring := outstring + InfoText[TITLE];
                    'A': outstring := outstring + InfoText[ARTIST];
                    'B': outstring := outstring + InfoText[ALBUM];
                    'Y': outstring := outstring + InfoText[YEAR];
                    'G': outstring := outstring + InfoText[GENRE];
                    'C': outstring := outstring + InfoText[COMMENT];
                    'L': outstring := outstring + InfoText[TRACK_LENGTH]
                  end; // case OrderStr[1] of
                  Delete(OrderStr,1,2);
                end; // if (OrderStr[1] <> '') then
              end; // While OrderStr > '' do
              OutData := Pchar(OutString);

            end // if ID3Tag = TRUE then
            else
            begin // File has no TAG or isn't a MP3 File, use artist and title from winamp
              WA_Window_Caption(hwndWinamp,fTitle,fArtist);

              if fTitle <> '' then
                InfoText[TITLE] := StringReplace(IniText[TITLE],'%TITLE',fTitle,[rfReplaceAll,rfIgnoreCase]);
              if fArtist <> '' then
                InfoText[ARTIST] := StringReplace(IniText[ARTIST],'%ARTIST',fArtist,[rfReplaceAll,rfIgnoreCase]);

              While OrderStr > '' do
              begin
                if (OrderStr[1] <> '') then
                begin
                  case OrderStr[1] of
                    'S': outstring := outstring + WAPlaying;
                    'T': outstring := outstring + InfoText[TITLE];
                    'A': outstring := outstring + InfoText[ARTIST];
                    'L': outstring := outstring + InfoText[TRACK_LENGTH]
                  end; // case OrderStr[1] of
                  Delete(OrderStr,1,2);
                end; // if (OrderStr[1] <> '') then
              end; // While OrderStr > '' do
            OutData := Pchar(OutString);

            end; //else  if WA_GetID3 then
          end
          else
          begin
            // Didn't find default playlist
            OutData := pchar(IniText[CANT_FIND_PLAYLIST]);
          end; // if WA_GetTrackFileName

        end; // case 1
      3: // Winamp is paused
        begin
          OutData := Pchar(StringReplace(IniText[IS_PAUSED],'%Version',WinAMpVersion,[rfReplaceAll,rfIgnoreCase]));
        end;
      else
        OutData := pchar(IniText[CANT_GET_FROM_WINAMP]);
    end; // case WA_State(hwndWinamp)
  end
  else
  begin
    // Winamp isn't running
    OutData := Pchar(IniText[WINAMP_NOT_RUNNING]);
  end; // if hwndWinamp > 0 then

  strcopy(data, OutData);

  result := 3; // Return data
end;

// Returns to mIRC just specified info
function WA_Link_Raw_Stats(mWnd: hWnd; aWnd: hWnd; Data: PChar; Parms: PChar;
Show: Boolean; NoPause: Boolean ): Integer; export; stdcall;
var
  hwndWinamp   : THandle;
  TrackNo      : word;
  TrackFileName: String;
  FileType     : String;

  fTitle       : String;
  fArtist      : String;
  fAlbum       : String;
  fYear        : String;
  fcomment     : string;
  fgenre       : string;

  Outdata      : Pchar;
  ID3Tag       : Boolean;

begin
  hwndWinamp := FindWindow('Winamp v1.x', nil);

  OutData := pchar('$false');

  if UpperCase(Data) = 'WADIR' then // The only RAW command that works with winamp not running
    OutData:= pchar(WA_WinAmpDir); // Returns the dir of winamp

  if hwndWinamp > 0 then
  begin
    If UpperCase(Data) = 'VERSION' then
      OutData := pchar(WA_Version(hwndWinamp)) // Returns winamp version
    else if UpperCase(Data) = 'GETSHUFFLE' then
    begin
      if WA_Get_Shuffle(hwndWinamp) = TRUE then
        OutData :=  pchar('$SHUFFLE_ON')
      else
        OutData :=  pchar('$SHUFFLE_OFF')
    end
    else if UpperCase(Data) = 'GETREPEAT' then
    begin
      if WA_Get_Repeat(hwndWinamp) = TRUE then
        OutData :=  pchar('$REPEAT_ON')
      else
        OutData :=  pchar('$REPEAT_OFF')
    end;

    // Winamp is running
    case WA_playState(hwndWinamp) of
    0: // Winamp is stopped
      begin
        If UpperCase(Data) = 'STATE' then
          OutData := pchar('$WA_STOPPED') // Returns winamp playstate
      end;
    1: // Winamp is playing
      begin
        WA_WritePlayList(hwndWinamp);
        TrackNo := WA_TrackNumber(hwndWinamp);

        If UpperCase(Data) = 'STATE' then
          OutData := pchar('$WA_PLAYING')  // Returns winamp playstate
        else If UpperCase(Data) = 'TRACKSEC' then
          OutData := pchar(inttostr(WA_TrackLength(hwndWinamp)))
        else If UpperCase(Data) = 'POSSEC' then
          OutData := pchar(inttostr(WA_TrackPos(hwndWinamp) div 1000))
        else If UpperCase(Data) = 'SAMPLERATE' then
          OutData := pchar(WA_Get_Samplerate(hwndWinamp))
        else If UpperCase(Data) = 'CHANNELS' then
          OutData := pchar(WA_Get_Channels(hwndWinamp))
        else If UpperCase(Data) = 'BITRATE' then
          OutData := pchar(WA_Get_Bitrate(hwndWinamp))
        else if (UpperCase(Data) = 'TRACKNO') or
                (UpperCase(Data) = 'TRACKFILENAME') or
                (UpperCase(Data) = 'FILETYPE') or
                (UpperCase(Data) = 'TRACKSIZE') or
                (UpperCase(Data) = 'TITLE') or
                (UpperCase(Data) = 'ARTIST') or
                (UpperCase(Data) = 'ALBUM') or                
                (UpperCase(Data) = 'COMMENT') or
                (UpperCase(Data) = 'YEAR') or
                (UpperCase(Data) = 'COMMENT') or
                (UpperCase(Data) = 'GENRE') then
        begin
          if WA_GetTrackFileName(hwndWinamp,TrackNo,TrackFileName,FileType) then
          begin
            if (UpperCase(Data) = 'TITLE') or
               (UpperCase(Data) = 'ARTIST') or
               (UpperCase(Data) = 'ALBUM') or
               (UpperCase(Data) = 'YEAR') or
               (UpperCase(Data) = 'COMMENT') or
               (UpperCase(Data) = 'GENRE') then
            begin
              ID3Tag := false;

              if UpperCase(FileType) = 'MP3' then // Check for ID Tags
              begin
                if ID3V2_GetID3(trackFilename,fTitle,fArtist,fAlbum,fYear,fcomment,fgenre) then
                  ID3Tag := True
                else
                if ID3V1_GetID3(trackFilename,fTitle,fArtist,fAlbum,fYear,fcomment,fgenre) then
                  ID3Tag := True
              end;

              if ID3Tag = TRUE then // ID Tag found
              begin
                If UpperCase(Data) = 'TITLE' then
                begin
                  if fTitle <> '' then
                    OutData := pchar(fTitle);
                end

                else
                If UpperCase(Data) = 'ARTIST' then
                begin
                  if fArtist <> '' then
                    OutData := pchar(fArtist);
                end

                else
                If UpperCase(Data) = 'ALBUM' then
                begin
                  if fAlbum <> '' then
                    OutData := pchar(fAlbum);
                end

                else
                If UpperCase(Data) = 'YEAR' then
                begin
                  if fYear <> '' then
                    OutData := pchar(fYear);
                end

                else
                If UpperCase(Data) = 'COMMENT' then
                begin
                  if fComment <> '' then
                    OutData := pchar(fComment);
                end

                else
                If UpperCase(Data) = 'GENRE' then
                begin
                  if fGenre <> '' then
                    OutData := pchar(fGenre);
                end
              end
              else // if ID3Tag = FALSE then only artist and title can be found
              begin
                WA_Window_Caption(hwndWinamp,fTitle,fArtist);
                If UpperCase(Data) = 'TITLE' then
                  OutData := pchar(fTitle)
                else If UpperCase(Data) = 'ARTIST' then
                   OutData := pchar(fArtist)

              end; // if ID3Tag = TRUE then
            end; // if (UpperCase(Data) = 'TITLE').......

            If UpperCase(Data) = 'TRACKNO' then
              OutData := pchar(inttostr(TrackNo)) // Returns the track number in playlist
            else If UpperCase(Data) = 'TRACKFILENAME' then
              OutData := pchar(TrackFileName) // Returns the current playing filename with path
            else If UpperCase(Data) = 'FILETYPE' then
              OutData := pchar(FileType) // Returns the filetype
            else If UpperCase(Data) = 'TRACKSIZE' then
              OutData := pchar(inttostr(WA_Get_TrackSize(TrackFileName))) // Returns the filesize in bytes
        end
        else
          OutData := pchar('$false');
        end; // if WA_GetTrackFileName(hwndWinamp,TrackNo,TrackFileName,FileType) then

      end; // end case 1

    3: // Winamp is paused
      begin
        If UpperCase(Data) = 'STATE' then
          OutData := pchar('$WA_PAUSED'); // Returns winamp playstate
      end
    end; // End case
  end // if hwndWinamp > 0 then
  else
  If UpperCase(Data) = 'STATE' then
    OutData := pchar('$WA_NOTRUNNING');

  strcopy(data, OutData);
  result := 3; // Return data
end;

// Commands Winamp.
function WA_Link_Command(mWnd: hWnd; aWnd: hWnd; Data: PChar; Parms: PChar;
Show: Boolean; NoPause: Boolean ): Integer; export; stdcall;
var
  hwndWinamp    : THandle;
  CommandType   : String;
  Command       : String;
  SecondParam   : integer;
  Outdata       : Pchar;

begin
  hwndWinamp := FindWindow('Winamp v1.x', nil);

  OutData := '';

  if hwndWinamp > 0 then // Is winamp running
  begin // Commands with %1
    if UpperCase(Data) = 'STOP' then
      WA_Stop_Track(hwndWinamp)
    else
    if UpperCase(Data) = 'PLAY' then
      WA_Play_Track(hwndWinamp)
    else
    if UpperCase(Data) = 'PAUSE' then
      WA_Pause_Track(hwndWinamp)
    else
    if UpperCase(Data) = 'NEXT' then
      WA_Next_Track(hwndWinamp)
    else
    if UpperCase(Data) = 'PREV' then
      WA_Previous_Track(hwndWinamp)
    else
    if UpperCase(Data) = 'SHUFFLE' then
      WA_Toggle_Shuffle(hwndWinamp)
    else
    if UpperCase(Data) = 'REPEAT' then
      WA_Toggle_Repeat(hwndWinamp)
    else
    if UpperCase(Data) = 'FADESTOP' then
      WA_Fade_Stop(hwndWinamp)
    else    
    if UpperCase(Data) = 'BOFPL' then
      WA_BOF_Playlist(hwndWinamp)
    else
    if UpperCase(Data) = 'EOFPL' then
      WA_EOF_Playlist(hwndWinamp)
    else
    if UpperCase(Data) = 'FFW5' then
      WA_Forward_5_Sec(hwndWinamp)
    else
    if UpperCase(Data) = 'REW5' then
      WA_Backward_5_Sec(hwndWinamp)
    else
    if UpperCase(Data) = 'ONTOP' then
      WA_Toggle_Stay_on_top(hwndWinamp)
    else
    if UpperCase(Data) = 'VISPLUG' then
      WA_Exec_VisPlugin(hwndWinamp)
    else
    if UpperCase(Data) = 'OPEN' then
      WA_Open(hwndWinamp)
    else
    if UpperCase(Data) = 'WRITEPL' then
      WA_WritePlayList(hwndWinamp)
    else
    if UpperCase(Data) = 'HIDE' then
      WA_Hide(hwndWinamp)
    else
    if UpperCase(Data) = 'SHOW' then
      WA_Show(hwndWinamp)
    else
    if UpperCase(Data) = 'RESTORE' then
      WA_Restore(hwndWinamp)
    else
    if UpperCase(Data) = 'MINIMIZE' then
      WA_Minimize(hwndWinamp)
    else
    if UpperCase(Data) = 'PLAYLIST' then
      WA_Toggle_PL(hwndWinamp)
    else
    if UpperCase(Data) = 'EQ' then
      WA_Toggle_EQ(hwndWinamp)
    else
    if UpperCase(Data) = 'SHADE' then
      WA_Toggle_Shade(hwndWinamp)
    else
    if UpperCase(Data) = 'PLSHADE' then
      WA_Toggle_PL_Shade(hwndWinamp)
    else
    if UpperCase(Data) = 'CLOSE' then
      WA_Close(hwndWinamp)
    else
    begin // Commands that require values
      CommandType := Uppercase(copy(Data,1,pos(' ',data)-1));

      // VOL command
      if CommandType = 'VOL' then
      begin
        Command := uppercase(copy(Data,(pos(' ',data)+1),Length(Data)-1));

        if Command = 'UP' then // VOL_UP
          WA_Volume_Up(hwndWinamp)
        else
        if Command = 'DOWN' then // VOL_DOWN
          WA_Volume_Down(hwndWinamp)
        else  // VOL 255 100%
        begin
          try
            SecondParam := strtoint(Command);
            WA_Volume_Set(hwndWinamp,SecondParam); //0 to 100 (Winamp 0 to 256)
          except
            on EConvertError do;
          end; // try
        end;
      end // if CommandType = 'VOL' then
      else

      // PAN command
      if CommandType = 'PAN' then // PAN
      begin
        Command := uppercase(copy(Data,(pos(' ',data)+1),Length(Data)-1));
        try
          SecondParam := strtoint(Command);
          WA_Panning_Set(hwndWinamp,SecondParam);   // -100 to 100
        except
          on EConvertError do;
        end; // try
      end // if CommandType = 'PAN' then
      else

      // JUMP command
      if CommandType = 'JUMP' then // JUMP
      begin
        Command := uppercase(copy(Data,(pos(' ',data)+1),Length(Data)-1));
        try
          SecondParam := strtoint(Command);
          WA_Jump_Playlist(hwndWinamp,SecondParam);
        except
          on EConvertError do;
        end; // try
      end // if CommandType = 'JUMP' then
      else

      // FIND command
      if CommandType = 'FIND' then // FIND
      begin
        Command := uppercase(copy(Data,(pos(' ',data)+1),Length(Data)-1));
        OutData := pchar(WA_Find_Playlist(hwndWinamp,Command));
      end // if CommandType = 'FIND' then

      // SEEK command
      else
      if CommandType = 'SEEK' then // SEEK
      begin
        Command := uppercase(copy(Data,(pos(' ',data)+1),Length(Data)-1));
        try
          SecondParam := strtoint(Command);
          WA_Seek_Offset(hwndWinamp,SecondParam);  // 0 to 100 precent of track length
        except
          on EConvertError do;
        end; // try
      end; //if CommandType = 'SEEK' then

    end;
  end // if hwndWinamp > 0 then
  else
  begin
   if UpperCase(Data) = 'START' then
      WA_Start
    else
      // Return -1 (Winamp is not running)
      OutData := pchar('-1');
  end; // else if hwndWinamp > 0 then


  // Should wa link return some data?
  if OutData > '' then
  begin
    strcopy(data, OutData);
    result := 3; // Return data
  end
  else
    result := 1; // Return nothing

// OutData = -1 Winamp not running
// OutData = -2 No matches found in playlist
end;

// Returns the WA_Status version msgbox
function WA_Link_About(mWnd: hWnd; aWnd: hWnd; Data: PChar; Parms: PChar;
Show: Boolean; NoPause: Boolean ): Integer; export; stdcall;
begin
  if NOT NoPause then
    MessageBox(mWnd, Pchar(WA_LINK_MADE_BY), WA_LINK_VERSION, MB_OK);
  result := 0;
end;

exports
  LoadDll,           // Loads the DLL
  UnloadDll,         // Unloads the DLL
  WA_Link_About,     // Display the about dialog
  WA_Link_Stats,     // Returns current track info in selected theme format
  WA_Link_Command,   // Command Winamp to do something
  WA_Link_Raw_Stats; // Get raw info from Winamp

begin
end.
